from flask import Flask, render_template, request, jsonify
import requests
from bs4 import BeautifulSoup

app = Flask(__name__)

def calculate_cgpa(gpas):
    return round(sum(gpas) / len(gpas), 2)

@app.route("/")
def home():
    return render_template("CGPA.html")

@app.route("/get-result", methods=["POST"])
def get_result():
    roll = request.form.get("roll")
    reg = request.form.get("reg")
    year = request.form.get("year")

    url = "http://result.nu.ac.bd/"
    payload = {"exam": "Honours", "roll": roll, "reg": reg, "year": year}
    headers = {"User-Agent": "Mozilla/5.0"}

    response = requests.post(url, data=payload, headers=headers)
    soup = BeautifulSoup(response.text, "html.parser")

    tables = soup.find_all("table")
    if len(tables) < 2:
        return jsonify({"error": "Result not found"})

    rows = tables[1].find_all("tr")
    subjects, gpas = [], []

    for row in rows:
        cols = row.find_all("td")
        if len(cols) >= 5:
            subject = cols[1].text.strip()
            try:
                gpa = float(cols[4].text.strip())
                subjects.append({"subject": subject, "gpa": gpa})
                gpas.append(gpa)
            except:
                pass

    if not gpas:
        return jsonify({"error": "No GPA data found"})

    return jsonify({
        "roll": roll,
        "reg": reg,
        "year": year,
        "subjects": subjects,
        "cgpa": calculate_cgpa(gpas)
    })
